# Prof-TC
# Mai 2021
# Etalonnage d'une photorésistance
# Tracé de U=f(I) pour une photorésistance

#Affichage du nom du programme
print("_________________________________________________________")
print("Etalonnage d'une photorésistance")
print("_________________________________________________________")

#Importation des bibliothèques
import matplotlib.pyplot as plt
import numpy as np
from math import log10

# Valeurs expérimentales à modifier selon l'expérience (E en lux et U en volt)
print("**********************************************")
U=[0.88, 0.80, 0.74, 0.69, 0.64, 0.60, 0.56, 0.53, 0.50, 0.46, 0.44, 0.41, 0.35]
E=[421, 370, 326, 289, 259, 234, 214, 196, 181, 163, 155, 144, 130 ]
print("**********************************************")

# Nombre de points expérimentaux
K=len(U)

# Détermination des valeurs de L=log(E)
L=[]
for i in range(K):
    L.append(log10(E[i]))

#Affichage des valeurs expérimentales et du nombre de points
print("valeurs de U: ",U)
print("valeurs de L: ",L)
print("Il y a ",K," couples de points")
print("**********************************************")

#Initialisation des variables
Umoy=0.0
Lmoy=0.0
N=0.0
D=0.0
a=0.0
b=0.0
Umin=U[0]
Lmin=L[0]
Umax=U[K-1]
Lmax=L[K-1]

# Initialisation de la figure
fig, ax = plt.subplots()

#Calcul des coefficients de la droite représentant U=f(I)
for i in range (K):
    Umoy=Umoy+U[i]
    Lmoy=Lmoy+L[i]

Umoy=Umoy/(K)
Lmoy=Lmoy/(K)

for i in range (K):
    N=N+(U[i]-Umoy)*(L[i]-Lmoy)
    D=D+(U[i]-Umoy)*(U[i]-Umoy)

a=N/D #Coefficient directeur de la droite
b=Lmoy-a*Umoy #Ordonnée à l'origine de la droite

#Mise en écriture avec 5 décimales pour l'affichage de l'équation
A=round(a,3)
B=round (b,3)
c=10**b
C=round(c,3)

#Tracé des axes, labels et titre du graphique
plt.axis([Umin, Umax, Lmin, Lmax])
plt.xlabel('U (V)',color='green', fontsize=20)
plt.ylabel('L (sans unité)',color='green', fontsize=20)
plt.title("Etalonnage d'une photorésistance", color='red', fontsize=10)
plt.grid()

#Tracé des valeurs expérimentales
plt.scatter(U,L,marker='o',color='r',linewidth = 4)

#Tracé de la droite
x=np.linspace(0,Umax+1,200)
y=a*x+b
plt.plot(x,y,linewidth = 2)

#Ecriture de l'équation de la droite
plt.text((Umax+Umin)/2, Lmax-(Lmax-Lmin)*0.1, "L = "+str(A)+" x U + "+str(B), color='green', fontsize=10,horizontalalignment = 'center')
plt.text((Umax+Umin)/2, Lmax-(Lmax-Lmin)*0.2, "A = "+str(A)+"   B = "+str(B)+"   C = "+str(C), color='red', fontsize=10,horizontalalignment = 'center')

#Affichage du graphique
plt.show()

# Sauvegarde de la figure dans le dossier où se trouve le programme
fig.savefig("Etalonnage d'une photorésistance")

print("********************************************************")
print("L'équation de la droite est: L = ",A," x U + ",B)
print("********************************************************")
print("L'équation de la courbe à utiliser sera donc: E = ",C,"x 10^(",A,"x U)")
print("********************************************************")

#Fin du programme